<!--
=========================================================
* Argon Dashboard - v1.2.0
=========================================================
* Product Page: https://www.creative-tim.com/product/argon-dashboard


* Copyright  Creative Tim (http://www.creative-tim.com)
* Coded by www.creative-tim.com



=========================================================
* The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
-->
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="Start your development with a Dashboard for Bootstrap 4.">
  <meta name="author" content="Creative Tim">
  <title>Argon Dashboard - Free Dashboard for Bootstrap 4</title>
  <!-- Favicon -->
  <link rel="icon" href="../assets/img/brand/favicon.png" type="image/png">
  <!-- Fonts -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
  <!-- Icons -->
  <link rel="stylesheet" href="../assets/vendor/nucleo/css/nucleo.css" type="text/css">
  <link rel="stylesheet" href="../assets/vendor/@fortawesome/fontawesome-free/css/all.min.css" type="text/css">
  <!-- Page plugins -->
  <!-- Argon CSS -->
  <link rel="stylesheet" href="../assets/css/argon.css?v=1.2.0" type="text/css">
</head>

<body>
  <!-- Sidenav -->
  <nav class="sidenav navbar navbar-vertical  fixed-left  navbar-expand-xs navbar-light bg-white" id="sidenav-main">
    <div class="scrollbar-inner">
      <!-- Brand -->
      <div class="sidenav-header  align-items-center">
        <a class="navbar-brand" href="javascript:void(0)">
          <img src="../assets/img/brand/blue.png" class="navbar-brand-img" alt="...">
        </a>
      </div>
      <div class="navbar-inner">
        <!-- Collapse -->
        <div class="collapse navbar-collapse" id="sidenav-collapse-main">
          <!-- Nav items -->
          <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" href="{{ route('home') }}">
                    <i class="ni ni-tv-2 text-primary"></i> {{ __('Dashboard') }}
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="#navbar-examples" data-toggle="collapse" role="button" aria-expanded="true" aria-controls="navbar-examples">
                    <i class="fab fa-laravel" style="color: #f4645f;"></i>
                    <span class="nav-link-text" style="color: #f4645f;">{{ __('Laravel Examples') }}</span>
                </a>

                <div class="collapse show" id="navbar-examples">
                    <ul class="nav nav-sm flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('profile.edit') }}">
                                {{ __('User profile') }}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('user.index') }}">
                                {{ __('User Management') }}
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="#">
                    <i class="ni ni-planet text-blue"></i> {{ __('Icons') }}
                </a>
            </li>
            <li class="nav-item ">
                <a class="nav-link" href="{{ route('map') }}">
                    <i class="ni ni-pin-3 text-orange"></i> {{ __('Maps') }}
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="{{ route('table') }}">
                  <i class="ni ni-bullet-list-67 text-default"></i>
                  <span class="nav-link-text">Tables</span>
                </a>
              </li>
            <li class="nav-item mb-5 mr-4 ml-4 pl-1 bg-danger" style="position: absolute; bottom: 0;">
                <a class="nav-link text-white" href="{{route('upgrade')}}">
                    <i class="ni ni-cloud-download-95"></i> Upgrade to PRO
                </a>
            </li>
        </ul>
          <!-- Divider -->
          <hr class="my-3">
          <!-- Heading -->
          <h6 class="navbar-heading p-0 text-muted">
            <span class="docs-normal">Documentation</span>
          </h6>
          <!-- Navigation -->
          <ul class="navbar-nav mb-md-3">
            <li class="nav-item">
              <a class="nav-link" href="https://demos.creative-tim.com/argon-dashboard/docs/getting-started/overview.html" target="_blank">
                <i class="ni ni-spaceship"></i>
                <span class="nav-link-text">Getting started</span>
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="https://demos.creative-tim.com/argon-dashboard/docs/foundation/colors.html" target="_blank">
                <i class="ni ni-palette"></i>
                <span class="nav-link-text">Foundation</span>
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="https://demos.creative-tim.com/argon-dashboard/docs/components/alerts.html" target="_blank">
                <i class="ni ni-ui-04"></i>
                <span class="nav-link-text">Components</span>
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="https://demos.creative-tim.com/argon-dashboard/docs/plugins/charts.html" target="_blank">
                <i class="ni ni-chart-pie-35"></i>
                <span class="nav-link-text">Plugins</span>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </nav>
  <!-- Main content -->
  <div class="main-content" id="panel">
    <!-- Topnav -->
    <nav class="navbar navbar-top navbar-expand navbar-dark bg-primary border-bottom">
      <div class="container-fluid">
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <!-- Search form -->
          <form class="navbar-search navbar-search-light form-inline mr-sm-3" id="navbar-search-main">
            <div class="form-group mb-0">
              <div class="input-group input-group-alternative input-group-merge">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fas fa-search"></i></span>
                </div>
                <input class="form-control" placeholder="Search" type="text">
              </div>
            </div>
            <button type="button" class="close" data-action="search-close" data-target="#navbar-search-main" aria-label="Close">
              <span aria-hidden="true">×</span>
            </button>
          </form>
          <!-- Navbar links -->
          <ul class="navbar-nav align-items-center  ml-md-auto ">
            <li class="nav-item d-xl-none">
              <!-- Sidenav toggler -->
              <div class="pr-3 sidenav-toggler sidenav-toggler-dark" data-action="sidenav-pin" data-target="#sidenav-main">
                <div class="sidenav-toggler-inner">
                  <i class="sidenav-toggler-line"></i>
                  <i class="sidenav-toggler-line"></i>
                  <i class="sidenav-toggler-line"></i>
                </div>
              </div>
            </li>
            <li class="nav-item d-sm-none">
              <a class="nav-link" href="#" data-action="search-show" data-target="#navbar-search-main">
                <i class="ni ni-zoom-split-in"></i>
              </a>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="ni ni-bell-55"></i>
              </a>
              <div class="dropdown-menu dropdown-menu-xl  dropdown-menu-right  py-0 overflow-hidden">
                <!-- Dropdown header -->
                <div class="px-3 py-3">
                  <h6 class="text-sm text-muted m-0">You have <strong class="text-primary">13</strong> notifications.</h6>
                </div>
                <!-- List group -->
                <div class="list-group list-group-flush">
                  <a href="#!" class="list-group-item list-group-item-action">
                    <div class="row align-items-center">
                      <div class="col-auto">
                        <!-- Avatar -->
                        <img alt="Image placeholder" src="../assets/img/theme/team-1.jpg" class="avatar rounded-circle">
                      </div>
                      <div class="col ml--2">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <h4 class="mb-0 text-sm">John Snow</h4>
                          </div>
                          <div class="text-right text-muted">
                            <small>2 hrs ago</small>
                          </div>
                        </div>
                        <p class="text-sm mb-0">Let's meet at Starbucks at 11:30. Wdyt?</p>
                      </div>
                    </div>
                  </a>
                  <a href="#!" class="list-group-item list-group-item-action">
                    <div class="row align-items-center">
                      <div class="col-auto">
                        <!-- Avatar -->
                        <img alt="Image placeholder" src="../assets/img/theme/team-2.jpg" class="avatar rounded-circle">
                      </div>
                      <div class="col ml--2">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <h4 class="mb-0 text-sm">John Snow</h4>
                          </div>
                          <div class="text-right text-muted">
                            <small>3 hrs ago</small>
                          </div>
                        </div>
                        <p class="text-sm mb-0">A new issue has been reported for Argon.</p>
                      </div>
                    </div>
                  </a>
                  <a href="#!" class="list-group-item list-group-item-action">
                    <div class="row align-items-center">
                      <div class="col-auto">
                        <!-- Avatar -->
                        <img alt="Image placeholder" src="../assets/img/theme/team-3.jpg" class="avatar rounded-circle">
                      </div>
                      <div class="col ml--2">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <h4 class="mb-0 text-sm">John Snow</h4>
                          </div>
                          <div class="text-right text-muted">
                            <small>5 hrs ago</small>
                          </div>
                        </div>
                        <p class="text-sm mb-0">Your posts have been liked a lot.</p>
                      </div>
                    </div>
                  </a>
                  <a href="#!" class="list-group-item list-group-item-action">
                    <div class="row align-items-center">
                      <div class="col-auto">
                        <!-- Avatar -->
                        <img alt="Image placeholder" src="../assets/img/theme/team-4.jpg" class="avatar rounded-circle">
                      </div>
                      <div class="col ml--2">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <h4 class="mb-0 text-sm">John Snow</h4>
                          </div>
                          <div class="text-right text-muted">
                            <small>2 hrs ago</small>
                          </div>
                        </div>
                        <p class="text-sm mb-0">Let's meet at Starbucks at 11:30. Wdyt?</p>
                      </div>
                    </div>
                  </a>
                  <a href="#!" class="list-group-item list-group-item-action">
                    <div class="row align-items-center">
                      <div class="col-auto">
                        <!-- Avatar -->
                        <img alt="Image placeholder" src="../assets/img/theme/team-5.jpg" class="avatar rounded-circle">
                      </div>
                      <div class="col ml--2">
                        <div class="d-flex justify-content-between align-items-center">
                          <div>
                            <h4 class="mb-0 text-sm">John Snow</h4>
                          </div>
                          <div class="text-right text-muted">
                            <small>3 hrs ago</small>
                          </div>
                        </div>
                        <p class="text-sm mb-0">A new issue has been reported for Argon.</p>
                      </div>
                    </div>
                  </a>
                </div>
                <!-- View all -->
                <a href="#!" class="dropdown-item text-center text-primary font-weight-bold py-3">View all</a>
              </div>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="ni ni-ungroup"></i>
              </a>
              <div class="dropdown-menu dropdown-menu-lg dropdown-menu-dark bg-default  dropdown-menu-right ">
                <div class="row shortcuts px-4">
                  <a href="#!" class="col-4 shortcut-item">
                    <span class="shortcut-media avatar rounded-circle bg-gradient-red">
                      <i class="ni ni-calendar-grid-58"></i>
                    </span>
                    <small>Calendar</small>
                  </a>
                  <a href="#!" class="col-4 shortcut-item">
                    <span class="shortcut-media avatar rounded-circle bg-gradient-orange">
                      <i class="ni ni-email-83"></i>
                    </span>
                    <small>Email</small>
                  </a>
                  <a href="#!" class="col-4 shortcut-item">
                    <span class="shortcut-media avatar rounded-circle bg-gradient-info">
                      <i class="ni ni-credit-card"></i>
                    </span>
                    <small>Payments</small>
                  </a>
                  <a href="#!" class="col-4 shortcut-item">
                    <span class="shortcut-media avatar rounded-circle bg-gradient-green">
                      <i class="ni ni-books"></i>
                    </span>
                    <small>Reports</small>
                  </a>
                  <a href="#!" class="col-4 shortcut-item">
                    <span class="shortcut-media avatar rounded-circle bg-gradient-purple">
                      <i class="ni ni-pin-3"></i>
                    </span>
                    <small>Maps</small>
                  </a>
                  <a href="#!" class="col-4 shortcut-item">
                    <span class="shortcut-media avatar rounded-circle bg-gradient-yellow">
                      <i class="ni ni-basket"></i>
                    </span>
                    <small>Shop</small>
                  </a>
                </div>
              </div>
            </li>
          </ul>
          <ul class="navbar-nav align-items-center  ml-auto ml-md-0 ">
            <li class="nav-item dropdown">
              <a class="nav-link pr-0" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <div class="media align-items-center">
                  <span class="avatar avatar-sm rounded-circle">
                    <img alt="Image placeholder" src="../assets/img/theme/team-4.jpg">
                  </span>
                  <div class="media-body  ml-2  d-none d-lg-block">
                    <span class="mb-0 text-sm  font-weight-bold">John Snow</span>
                  </div>
                </div>
              </a>
              <div class="dropdown-menu  dropdown-menu-right ">
                <div class="dropdown-header noti-title">
                  <h6 class="text-overflow m-0">Welcome!</h6>
                </div>
                <a href="#!" class="dropdown-item">
                  <i class="ni ni-single-02"></i>
                  <span>My profile</span>
                </a>
                <a href="#!" class="dropdown-item">
                  <i class="ni ni-settings-gear-65"></i>
                  <span>Settings</span>
                </a>
                <a href="#!" class="dropdown-item">
                  <i class="ni ni-calendar-grid-58"></i>
                  <span>Activity</span>
                </a>
                <a href="#!" class="dropdown-item">
                  <i class="ni ni-support-16"></i>
                  <span>Support</span>
                </a>
                <div class="dropdown-divider"></div>
                <a href="#!" class="dropdown-item">
                  <i class="ni ni-user-run"></i>
                  <span>Logout</span>
                </a>
              </div>
            </li>
          </ul>
        </div>
      </div>
    </nav>
    <!-- Header -->
    <!-- Header -->
    <div class="header bg-primary pb-6">
      <div class="container-fluid">
        <div class="header-body">
          <div class="row align-items-center py-4">
            <div class="col-lg-6 col-7">
              <h6 class="h2 text-white d-inline-block mb-0">Icons</h6>
              <nav aria-label="breadcrumb" class="d-none d-md-inline-block ml-md-4">
                <ol class="breadcrumb breadcrumb-links breadcrumb-dark">
                  <li class="breadcrumb-item"><a href="#"><i class="fas fa-home"></i></a></li>
                  <li class="breadcrumb-item"><a href="#">Components</a></li>
                  <li class="breadcrumb-item active" aria-current="page">Icons</li>
                </ol>
              </nav>
            </div>
            <div class="col-lg-6 col-5 text-right">
              <a href="#" class="btn btn-sm btn-neutral">New</a>
              <a href="#" class="btn btn-sm btn-neutral">Filters</a>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Page content -->
    <div class="container-fluid mt--6">
      <div class="row justify-content-center">
        <div class=" col ">
          <div class="card">
            <div class="card-header bg-transparent">
              <h3 class="mb-0">Icons</h3>
            </div>
            <div class="card-body">
              <div class="row icon-examples">
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="active-40" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-active-40"></i>
                      <span>active-40</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="air-baloon" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-air-baloon"></i>
                      <span>air-baloon</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="album-2" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-album-2"></i>
                      <span>album-2</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="align-center" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-align-center"></i>
                      <span>align-center</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="align-left-2" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-align-left-2"></i>
                      <span>align-left-2</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="ambulance" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-ambulance"></i>
                      <span>ambulance</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="app" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-app"></i>
                      <span>app</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="archive-2" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-archive-2"></i>
                      <span>archive-2</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="atom" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-atom"></i>
                      <span>atom</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="badge" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-badge"></i>
                      <span>badge</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bag-17" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bag-17"></i>
                      <span>bag-17</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="basket" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-basket"></i>
                      <span>basket</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bell-55" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bell-55"></i>
                      <span>bell-55</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bold-down" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bold-down"></i>
                      <span>bold-down</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bold-left" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bold-left"></i>
                      <span>bold-left</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bold-right" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bold-right"></i>
                      <span>bold-right</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bold-up" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bold-up"></i>
                      <span>bold-up</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bold" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bold"></i>
                      <span>bold</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="book-bookmark" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-book-bookmark"></i>
                      <span>book-bookmark</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="books" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-books"></i>
                      <span>books</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="box-2" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-box-2"></i>
                      <span>box-2</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="briefcase-24" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-briefcase-24"></i>
                      <span>briefcase-24</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="building" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-building"></i>
                      <span>building</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bulb-61" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bulb-61"></i>
                      <span>bulb-61</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bullet-list-67" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bullet-list-67"></i>
                      <span>bullet-list-67</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="bus-front-12" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-bus-front-12"></i>
                      <span>bus-front-12</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="button-pause" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-button-pause"></i>
                      <span>button-pause</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="button-play" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-button-play"></i>
                      <span>button-play</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="button-power" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-button-power"></i>
                      <span>button-power</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="calendar-grid-58" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-calendar-grid-58"></i>
                      <span>calendar-grid-58</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="camera-compact" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-camera-compact"></i>
                      <span>camera-compact</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="caps-small" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-caps-small"></i>
                      <span>caps-small</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="cart" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-cart"></i>
                      <span>cart</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="chart-bar-32" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-chart-bar-32"></i>
                      <span>chart-bar-32</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="chart-pie-35" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-chart-pie-35"></i>
                      <span>chart-pie-35</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="chat-round" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-chat-round"></i>
                      <span>chat-round</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="check-bold" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-check-bold"></i>
                      <span>check-bold</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="circle-08" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-circle-08"></i>
                      <span>circle-08</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="cloud-download-95" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-cloud-download-95"></i>
                      <span>cloud-download-95</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="cloud-upload-96" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-cloud-upload-96"></i>
                      <span>cloud-upload-96</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="compass-04" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-compass-04"></i>
                      <span>compass-04</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="controller" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-controller"></i>
                      <span>controller</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="credit-card" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-credit-card"></i>
                      <span>credit-card</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="curved-next" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-curved-next"></i>
                      <span>curved-next</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="delivery-fast" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-delivery-fast"></i>
                      <span>delivery-fast</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="diamond" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-diamond"></i>
                      <span>diamond</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="email-83" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-email-83"></i>
                      <span>email-83</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="fat-add" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-fat-add"></i>
                      <span>fat-add</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="fat-delete" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-fat-delete"></i>
                      <span>fat-delete</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="fat-remove" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-fat-remove"></i>
                      <span>fat-remove</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="favourite-28" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-favourite-28"></i>
                      <span>favourite-28</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="folder-17" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-folder-17"></i>
                      <span>folder-17</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="glasses-2" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-glasses-2"></i>
                      <span>glasses-2</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="hat-3" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-hat-3"></i>
                      <span>hat-3</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="headphones" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-headphones"></i>
                      <span>headphones</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="html5" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-html5"></i>
                      <span>html5</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="istanbul" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-istanbul"></i>
                      <span>istanbul</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="circle-08" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-circle-08"></i>
                      <span>circle-08</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="key-25" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-key-25"></i>
                      <span>key-25</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="laptop" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-laptop"></i>
                      <span>laptop</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="like-2" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-like-2"></i>
                      <span>like-2</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="lock-circle-open" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-lock-circle-open"></i>
                      <span>lock-circle-open</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="map-big" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-map-big"></i>
                      <span>map-big</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="mobile-button" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-mobile-button"></i>
                      <span>mobile-button</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="money-coins" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-money-coins"></i>
                      <span>money-coins</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="note-03" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-note-03"></i>
                      <span>note-03</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="notification-70" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-notification-70"></i>
                      <span>notification-70</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="palette" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-palette"></i>
                      <span>palette</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="paper-diploma" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-paper-diploma"></i>
                      <span>paper-diploma</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="pin-3" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-pin-3"></i>
                      <span>pin-3</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="planet" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-planet"></i>
                      <span>planet</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="ruler-pencil" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-ruler-pencil"></i>
                      <span>ruler-pencil</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="satisfied" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-satisfied"></i>
                      <span>satisfied</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="scissors" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-scissors"></i>
                      <span>scissors</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="send" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-send"></i>
                      <span>send</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="settings-gear-65" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-settings-gear-65"></i>
                      <span>settings-gear-65</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="settings" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-settings"></i>
                      <span>settings</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="single-02" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-single-02"></i>
                      <span>single-02</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="single-copy-04" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-single-copy-04"></i>
                      <span>single-copy-04</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="sound-wave" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-sound-wave"></i>
                      <span>sound-wave</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="spaceship" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-spaceship"></i>
                      <span>spaceship</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="square-pin" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-square-pin"></i>
                      <span>square-pin</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="support-16" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-support-16"></i>
                      <span>support-16</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="tablet-button" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-tablet-button"></i>
                      <span>tablet-button</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="tag" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-tag"></i>
                      <span>tag</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="tie-bow" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-tie-bow"></i>
                      <span>tie-bow</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="time-alarm" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-time-alarm"></i>
                      <span>time-alarm</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="trophy" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-trophy"></i>
                      <span>trophy</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="tv-2" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-tv-2"></i>
                      <span>tv-2</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="umbrella-13" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-umbrella-13"></i>
                      <span>umbrella-13</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="user-run" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-user-run"></i>
                      <span>user-run</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="vector" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-vector"></i>
                      <span>vector</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="watch-time" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-watch-time"></i>
                      <span>watch-time</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="world" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-world"></i>
                      <span>world</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="zoom-split-in" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-zoom-split-in"></i>
                      <span>zoom-split-in</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="collection" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-collection"></i>
                      <span>collection</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="image" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-image"></i>
                      <span>image</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="shop" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-shop"></i>
                      <span>shop</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="ungroup" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-ungroup"></i>
                      <span>ungroup</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="world-2" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-world-2"></i>
                      <span>world-2</span>
                    </div>
                  </button>
                </div>
                <div class="col-lg-3 col-md-6">
                  <button type="button" class="btn-icon-clipboard" data-clipboard-text="ui-04" title="Copy to clipboard">
                    <div>
                      <i class="ni ni-ui-04"></i>
                      <span>ui-04</span>
                    </div>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- Footer -->
      <footer class="footer pt-0">
        <div class="row align-items-center justify-content-lg-between">
          <div class="col-lg-6">
        <div class="copyright text-center text-xl-left text-muted">
            &copy; {{ now()->year }} <a href="https://www.creative-tim.com" class="font-weight-bold ml-1" target="_blank">Creative Tim</a> &amp;
            <a href="https://www.updivision.com" class="font-weight-bold ml-1" target="_blank">Updivision</a>
        </div>
          </div>
    <div class="col-xl-6">
        <ul class="nav nav-footer justify-content-center justify-content-xl-end">
            <li class="nav-item">
                <a href="https://www.creative-tim.com" class="nav-link" target="_blank">Creative Tim</a>
            </li>
            <li class="nav-item">
                <a href="https://www.updivision.com" class="nav-link" target="_blank">Updivision</a>
            </li>
            <li class="nav-item">
                <a href="https://www.creative-tim.com/presentation" class="nav-link" target="_blank">About Us</a>
            </li>
            <li class="nav-item">
                <a href="http://blog.creative-tim.com" class="nav-link" target="_blank">Blog</a>
            </li>
            <li class="nav-item">
                <a href="https://github.com/creativetimofficial/argon-dashboard/blob/master/LICENSE.md" class="nav-link" target="_blank">MIT License</a>
            </li>
        </ul>
    </div>
        </div>
      </footer>
    </div>
  </div>
  <!-- Argon Scripts -->
  <!-- Core -->
  <script src="../assets/vendor/jquery/dist/jquery.min.js"></script>
  <script src="../assets/vendor/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/vendor/js-cookie/js.cookie.js"></script>
  <script src="../assets/vendor/jquery.scrollbar/jquery.scrollbar.min.js"></script>
  <script src="../assets/vendor/jquery-scroll-lock/dist/jquery-scrollLock.min.js"></script>
  <!-- Optional JS -->
  <script src="../assets/vendor/clipboard/dist/clipboard.min.js"></script>
  <!-- Argon JS -->
  <script src="../assets/js/argon.js?v=1.2.0"></script>
</body>

</html>